<?php
/**
 * Copyright © Magento, Inc. All rights reserved.
 * See COPYING.txt for license details.
 */
namespace Expedux\Sales\Observer;

use Magento\Framework\Event\ObserverInterface;
use Magento\Customer\Api\AddressRepositoryInterface;

/**
 * Gift Message Observer Model
 *
 * @author      Magento Core Team <core@magentocommerce.com>
 */
class OrderDataBefore implements ObserverInterface
{
    /**
     * Gift message message
     *
     * @var \Magento\GiftMessage\Helper\Message|null
     */
    protected $_giftMessageMessage = null;

    /**
     * @var \Magento\GiftMessage\Model\MessageFactory
     */
    protected $_messageFactory;

    /**
     * @param \Magento\GiftMessage\Model\MessageFactory $messageFactory
     * @param \Magento\GiftMessage\Helper\Message $giftMessageMessage
     */
    public function __construct(
        \Magento\GiftMessage\Model\MessageFactory $messageFactory,
        \Magento\GiftMessage\Helper\Message $giftMessageMessage,
        AddressRepositoryInterface $addressRepository
    ) {
        $this->_messageFactory = $messageFactory;
        $this->_giftMessageMessage = $giftMessageMessage;
        $this->addressRepository = $addressRepository;
    }

    /**
     * Duplicates giftmessage from order to quote on import or reorder
     *
     * @param \Magento\Framework\Event\Observer $observer
     * @return $this
     */
    public function execute(\Magento\Framework\Event\Observer $observer)
    {  
        
      $delegateEmail = '';
      $addressId = $observer->getOrderCreateModel()->getQuote()->getBillingAddress()->getCustomerAddressId();
      if($addressId){
        $addressData = $this->addressRepository->getById($addressId);
        if($addressData){
            if($addressData->getCustomAttribute('delegate_email')){
                $delegateEmail = $addressData->getCustomAttribute('delegate_email')->getValue();
            }
        }
        
      }
      
        $observer->getOrderCreateModel()->getQuote()->getBillingAddress()->setDelegateEmail($delegateEmail);

        return $this;
    }
}
